(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     17503,        507]*)
(*NotebookOutlinePosition[     18347,        534]*)
(*  CellTagsIndexPosition[     18303,        530]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    \( (*\ \(Example\ 6.3 .. \) 1 : \ Error\ analysis\ with\ n = 
        8\ *) \n\(k[x_, \ s_] := \ Exp[x\ s];\)\), "\n", 
    \(\(f[x_] := \ 1 - \ \((Exp[x] - 1)\)/\((2\ x)\);\)\), "\n", 
    \(\(x1 = 0.0198550718;\)\), "\n", 
    \(\(x2 = 0.1016667613;\)\), "\n", 
    \(\(x3 = 0.2372337950;\)\), "\n", 
    \(\(x4 = 0.4082826788;\)\), "\n", 
    \(\(x5 = 0.5917173212;\)\), "\n", 
    \(\(x6 = 0.7627662050;\)\), "\n", 
    \(\(x7 = 0.8983332387;\)\), "\n", 
    \(\(x8 = 0.9801449282;\)\), "\n", 
    \(\(A1 = 0.0506142681;\)\), "\n", 
    \(\(A2 = 0.1111905172;\)\), "\n", 
    \(\(A3 = 0.1568533229;\)\), "\n", 
    \(\(A4 = 0.1813418917;\)\), "\n", 
    \(\(A5 = 0.1813418917;\)\), "\n", 
    \(\(A6 = 0.1568533229;\)\), "\n", 
    \(\(A7 = 0.1111905172;\)\), "\n", 
    \(\(A8 = 0.0506142681;\)\), "\n", 
    \(\(\[Lambda] = 0.5;\)\)}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(m = {{1 - A1*\[Lambda]*k[x1, x1], \(-A2\)*\[Lambda]*k[x1, x2], \ 
            \(-A3\)*\[Lambda]*k[x1, x3], \ \(-A4\)*\[Lambda]*k[x1, x4], 
            \(-A5\)*\[Lambda]*k[x1, x5], \(-A6\)*\[Lambda]*k[x1, x6]\ , 
            \(-A7\)*\[Lambda]*k[x1, x7], \(-A8\)*\[Lambda]*k[x1, x8]}, \n
          \t\t{\(-A1\)*\[Lambda]*k[x2, x1], \ 1 - A2*\[Lambda]*k[x2, x2], \n
            \t\t\(-A3\)*\[Lambda]*k[x2, x3], \ \(-A4\)*\[Lambda]*k[x2, x4], 
            \(-A5\)*\[Lambda]*k[x2, x5], \(-A6\)*\[Lambda]*k[x2, x6], 
            \(-A7\)*\[Lambda]*k[x2, x7], \(-A8\)*\[Lambda]*k[x2, x8]}, 
          \n{\(-A1\)*\[Lambda]*k[x3, x1], \ \(-A2\)*\[Lambda]*k[x3, x2], \n
            \t\t\t1 - A3*\[Lambda]*k[x3, x3], \ \(-A4\)*\[Lambda]*k[x3, x4], 
            \(-A5\)*\[Lambda]*k[x3, x5], \(-A6\)*\[Lambda]*k[x3, x6], 
            \(-A7\)*\[Lambda]*k[x3, x7], \(-A8\)*\[Lambda]*k[x3, x8]}, 
          \n{\(-A1\)*\[Lambda]*k[x4, x1], \ \(-A2\)*\[Lambda]*k[x4, x2], 
            \(-A3\)*\[Lambda]*k[x4, x3], \ 1 - A4*\[Lambda]*k[x4, x4], 
            \(-A5\)*\[Lambda]*k[x4, x5], \(-A6\)*\[Lambda]*k[x4, x6], 
            \(-A7\)*\[Lambda]*k[x4, x7], \(-A8\)*\[Lambda]*k[x4, x8]}, 
          \n{\(-A1\)*\[Lambda]*k[x5, x1], \ \(-A2\)*\[Lambda]*k[x5, x2], 
            \(-A3\)*\[Lambda]*k[x5, x3], \ \(-A4\)*\[Lambda]*k[x5, x4], 
            1 - A5*\[Lambda]*k[x5, x5], \(-A6\)*\[Lambda]*k[x5, x6], 
            \(-A7\)*\[Lambda]*k[x5, x7], \(-A8\)*\[Lambda]*k[x5, x8]}, \n
          \t\t{\(-A1\)*\[Lambda]*k[x6, x1], \ \(-A2\)*\[Lambda]*k[x6, x2], \n
            \t\t\t\(-A3\)*\[Lambda]*k[x6, x3], \ \(-A4\)*\[Lambda]*k[x6, x4], 
            \(-A5\)*\[Lambda]*k[x6, x5], 1 - A6*\[Lambda]*k[x6, x6], 
            \(-A7\)*\[Lambda]*k[x6, x7], \(-A8\)*\[Lambda]*k[x6, x8]}, \n
          \t\t{\(-A1\)*\[Lambda]*k[x7, x1], \ \(-A2\)*\[Lambda]*k[x7, x2], \n
            \t\t\t\(-A3\)*\[Lambda]*k[x7, x3], \ \(-A4\)*\[Lambda]*k[x7, x4], 
            \(-A5\)*\[Lambda]*k[x7, x5], \(-A6\)*\[Lambda]*k[x7, x6], 
            1 - A7*\[Lambda]*k[x7, x7], \(-A8\)*\[Lambda]*k[x7, x8]}, \n
          \t\t{\(-A1\)*\[Lambda]*k[x8, x1], \ \(-A2\)*\[Lambda]*k[x8, x2], \n
            \t\t\t\(-A3\)*\[Lambda]*k[x8, x3], \ \(-A4\)*\[Lambda]*k[x8, x4], 
            \(-A5\)*\[Lambda]*k[x8, x5], \(-A6\)*\[Lambda]*k[x8, x6], 
            \(-A7\)*\[Lambda]*k[x8, x7], 1 - A8*\[Lambda]*k[x8, x8]}\t} // N
        \)], "Input"],

Cell[BoxData[
    \({{0.974682887306739331`, \(-0.0557075965806293726`\), 
        \(-0.0787969454741595409`\), \(-0.0914089555210919257`\), 
        \(-0.0917424838131952924`\), \(-0.0796234555237341368`\), 
        \(-0.0565957781589904929`\), \(-0.0258044557929734441`\)}, {
        \(-0.0253582706470099727`\), 0.943827121525450607`, 
        \(-0.0803412132828371206`\), \(-0.094513790118913814`\), 
        \(-0.0962929355213177196`\), \(-0.0847505222728078599`\), 
        \(-0.0609118996139672219`\), \(-0.0279588698051309503`\)}, {
        \(-0.0254266192768695997`\), \(-0.0569524501759482326`\), 
        0.917032927472200576`, \(-0.0998925814076739726`\), 
        \(-0.104335567884358493`\), \(-0.0939833708313706672`\), 
        \(-0.0688006315245638955`\), \(-0.0319320381086065863`\)}, {
        \(-0.0255131196554376815`\), \(-0.0579515141666203081`\), 
        \(-0.0864029992185882989`\), 0.892881926234409206`, 
        \(-0.115448541942730775`\), \(-0.107081279601277246`\), 
        \(-0.0802279390804595138`\), \(-0.0377604602921597987`\)}, {
        \(-0.0256062106132808997`\), \(-0.0590424043939846576`\), 
        \(-0.0902460008876159314`\), \(-0.115448541942730775`\), 
        0.871315153919493923`, \(-0.123162659241460392`\), 
        \(-0.0945999793897351182`\), \(-0.0451981006775996707`\)}, {
        \(-0.0256933219546521041`\), \(-0.0600781305123605058`\), 
        \(-0.0939833708313706672`\), \(-0.123799237717980381`\), 
        \(-0.142391306736217782`\), 0.859672886447806661`, 
        \(-0.110312379629577872`\), \(-0.0534479221186179032`\)}, {
        \(-0.0257625736546827521`\), \(-0.0609118996139672219`\), 
        \(-0.0970551081513121971`\), \(-0.130844667390780777`\), 
        \(-0.154284193016736654`\), \(-0.155614559025592509`\), 
        0.875401006509537715`, \(-0.0610432788525784175`\)}, {
        \(-0.0258044557929734441`\), \(-0.0614206489722998316`\), 
        \(-0.0989572006535519577`\), \(-0.135288991778249045`\), 
        \(-0.161936730210724437`\), \(-0.165634800247277036`\), 
        \(-0.134101193240449467`\), 0.933860217800745928`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(d = Det[m]\)], "Input"],

Cell[BoxData[
    \(0.305785659202892379`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[x1]\)], "Input"],

Cell[BoxData[
    \(0.495003216340964691`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[x2]\)], "Input"],

Cell[BoxData[
    \(0.473699620158151812`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[x3]\)], "Input"],

Cell[BoxData[
    \(0.435709668149632634`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[x4]\)], "Input"],

Cell[BoxData[
    \(0.382496072152605037`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[x5]\)], "Input"],

Cell[BoxData[
    \(0.318011256634308203`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[x6]\)], "Input"],

Cell[BoxData[
    \(0.249967216792690072`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[x7]\)], "Input"],

Cell[BoxData[
    \(0.189884726635398575`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[x8]\)], "Input"],

Cell[BoxData[
    \(0.150716196727316731`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(d1 = 
      Det[\n\t\t{{0.495003216340964691`, \(-0.0557075965806293726`\), 
            \(-0.0787969454741595409`\), \(-0.0914089555210919257`\), 
            \(-0.0917424838131952924`\), \(-0.0796234555237341368`\), 
            \(-0.0565957781589904929`\), \(-0.0258044557929734441`\)}, {
            0.473699620158151812`, 0.943827121525450607`, 
            \(-0.0803412132828371206`\), \(-0.094513790118913814`\), 
            \(-0.0962929355213177196`\), \(-0.0847505222728078599`\), 
            \(-0.0609118996139672219`\), \(-0.0279588698051309503`\)}, {
            0.435709668149632634`, \(-0.0569524501759482326`\), 
            0.917032927472200576`, \(-0.0998925814076739726`\), 
            \(-0.104335567884358493`\), \(-0.0939833708313706672`\), 
            \(-0.0688006315245638955`\), \(-0.0319320381086065863`\)}, {
            0.382496072152605037`, \(-0.0579515141666203081`\), 
            \(-0.0864029992185882989`\), 0.892881926234409206`, 
            \(-0.115448541942730775`\), \(-0.107081279601277246`\), 
            \(-0.0802279390804595138`\), \(-0.0377604602921597987`\)}, {
            0.318011256634308203`, \(-0.0590424043939846576`\), 
            \(-0.0902460008876159314`\), \(-0.115448541942730775`\), 
            0.871315153919493923`, \(-0.123162659241460392`\), 
            \(-0.0945999793897351182`\), \(-0.0451981006775996707`\)}, {
            0.249967216792690072`, \(-0.0600781305123605058`\), 
            \(-0.0939833708313706672`\), \(-0.123799237717980381`\), 
            \(-0.142391306736217782`\), 0.859672886447806661`, 
            \(-0.110312379629577872`\), \(-0.0534479221186179032`\)}, {
            0.189884726635398575`, \(-0.0609118996139672219`\), 
            \(-0.0970551081513121971`\), \(-0.130844667390780777`\), 
            \(-0.154284193016736654`\), \(-0.155614559025592509`\), 
            0.875401006509537715`, \(-0.0610432788525784175`\)}, {
            0.150716196727316731`, \(-0.0614206489722998316`\), 
            \(-0.0989572006535519577`\), \(-0.135288991778249045`\), 
            \(-0.161936730210724437`\), \(-0.165634800247277036`\), 
            \(-0.134101193240449467`\), 0.933860217800745928`}}]\)], "Input"],

Cell[BoxData[
    \(0.305785659107841478`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CurlyPhi]1tilde = d1/d\)], "Input"],

Cell[BoxData[
    \(0.999999999689158691`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ The\ remaining\ values\ of\ d2,  ... , \ 
      d8\ and\ \[CurlyPhi]2tilde, \ 
      \( ... \ \[CurlyPhi]1tilde\ are\ the\ same\ as\ in\ error2 . nb\)\ \ *) 
      \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ The\ approximate\ solution\ is\ \[CurlyPhi]tilde, \ 
      given\ by\ *) \n
    \[CurlyPhi]tilde = 
      0.25\ *\ \((
            Exp[x1\ x] + Exp[x2\ x] + \ Exp[x3\ x] + \ Exp[x4\ x] + 
              Exp[x5\ x] + Exp[x6\ x] + Exp[x7\ x] + Exp[x8\ x])\)\  + 
        f[x]\)\)], "Input"],

Cell[BoxData[
    RowBox[{"1", "+", 
      RowBox[{
        StyleBox["0.25`",
          StyleBoxAutoDelete->True,
          PrintPrecision->2], " ", 
        RowBox[{"(", 
          RowBox[{
            SuperscriptBox["E", 
              RowBox[{
                StyleBox["0.0198550717999999992`",
                  StyleBoxAutoDelete->True,
                  PrintPrecision->9], " ", "x"}]], "+", 
            SuperscriptBox["E", 
              RowBox[{
                StyleBox["0.101666761300000008`",
                  StyleBoxAutoDelete->True,
                  PrintPrecision->10], " ", "x"}]], "+", 
            SuperscriptBox["E", 
              RowBox[{
                StyleBox["0.237233794999999991`",
                  StyleBoxAutoDelete->True,
                  PrintPrecision->10], " ", "x"}]], "+", 
            SuperscriptBox["E", 
              RowBox[{
                StyleBox["0.40828267880000002`",
                  StyleBoxAutoDelete->True,
                  PrintPrecision->10], " ", "x"}]], "+", 
            SuperscriptBox["E", 
              RowBox[{
                StyleBox["0.591717321199999979`",
                  StyleBoxAutoDelete->True,
                  PrintPrecision->10], " ", "x"}]], "+", 
            SuperscriptBox["E", 
              RowBox[{
                StyleBox["0.762766205000000052`",
                  StyleBoxAutoDelete->True,
                  PrintPrecision->10], " ", "x"}]], "+", 
            SuperscriptBox["E", 
              RowBox[{
                StyleBox["0.89833323870000008`",
                  StyleBoxAutoDelete->True,
                  PrintPrecision->10], " ", "x"}]], "+", 
            SuperscriptBox["E", 
              RowBox[{
                StyleBox["0.980144928200000009`",
                  StyleBoxAutoDelete->True,
                  PrintPrecision->10], " ", "x"}]]}], ")"}]}], "-", 
      \(\(\(-1\) + E\^x\)\/\(2\ x\)\)}]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{\(\[CurlyPhi][x_]\), ":=", 
      RowBox[{"1", "+", 
        RowBox[{
          StyleBox["0.25`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2], " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox["E", 
                RowBox[{
                  StyleBox["0.0198550717999999992`",
                    StyleBoxAutoDelete->True,
                    PrintPrecision->9], " ", "x"}]], "+", 
              SuperscriptBox["E", 
                RowBox[{
                  StyleBox["0.101666761300000008`",
                    StyleBoxAutoDelete->True,
                    PrintPrecision->10], " ", "x"}]], "+", 
              SuperscriptBox["E", 
                RowBox[{
                  StyleBox["0.237233794999999991`",
                    StyleBoxAutoDelete->True,
                    PrintPrecision->10], " ", "x"}]], "+", 
              SuperscriptBox["E", 
                RowBox[{
                  StyleBox["0.40828267880000002`",
                    StyleBoxAutoDelete->True,
                    PrintPrecision->10], " ", "x"}]], "+", 
              SuperscriptBox["E", 
                RowBox[{
                  StyleBox["0.591717321199999979`",
                    StyleBoxAutoDelete->True,
                    PrintPrecision->10], " ", "x"}]], "+", 
              SuperscriptBox["E", 
                RowBox[{
                  StyleBox["0.762766205000000052`",
                    StyleBoxAutoDelete->True,
                    PrintPrecision->10], " ", "x"}]], "+", 
              SuperscriptBox["E", 
                RowBox[{
                  StyleBox["0.89833323870000008`",
                    StyleBoxAutoDelete->True,
                    PrintPrecision->10], " ", "x"}]], "+", 
              SuperscriptBox["E", 
                RowBox[{
                  StyleBox["0.980144928200000009`",
                    StyleBoxAutoDelete->True,
                    PrintPrecision->10], " ", "x"}]]}], ")"}]}], "-", 
        \(\(\(-1\) + E\^x\)\/\(2\ x\)\)}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Limit[\[CurlyPhi][x], \ x -> 0]\)], "Input"],

Cell[BoxData[
    \(0.999943630649263504`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ 
      Exact\ solution\ is\ \[Phi][x] = 
        \(1. \ So\ the\ error\ is\n\t\[Phi][x]\  - \ \[CurlyPhi][x] = 
          \(1 - 999944 = \(0.000056\ at\ x = 0\)\)\)\ , \ 
      same\ as\ in\ error1 . nb\ and\ error2 . nb\ \ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CurlyPhi][x1]\)], "Input"],

Cell[BoxData[
    \(0.999942928127357433`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CurlyPhi][x2]\)], "Input"],

Cell[BoxData[
    \(0.999939910084566463`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CurlyPhi][x3]\)], "Input"],

Cell[BoxData[
    \(0.999934114448952193`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CurlyPhi][x4]\)], "Input"],

Cell[BoxData[
    \(0.999922949553364048`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CurlyPhi][x5]\)], "Input"],

Cell[BoxData[
    \(0.999898428342916112`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CurlyPhi][x6]\)], "Input"],

Cell[BoxData[
    \(0.999849932451892797`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CurlyPhi][x7]\)], "Input"],

Cell[BoxData[
    \(0.999779738331655387`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CurlyPhi][x8]\)], "Input"],

Cell[BoxData[
    \(0.999716976375820109`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[CurlyPhi][1]\)], "Input"],

Cell[BoxData[
    \(0.999698836105151578`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ So\ the\ error\ at\ x = 1\ is\ 0.000301*) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((m[\([1, 1]\)] - m[\([1, 2]\)] + m[\([1, 3]\)] - m[\([1, 4]\)] + 
          m[\([1, 5]\)] - m[\([1, 6]\)] - m[\([1, 7]\)] + m[\([1, 8]\)])\)/d
      \)], "Input"],

Cell[BoxData[
    \(3.47195741873042917`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ So\ we\ take\ B = 3.5\ *) \)], "Input"]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 509},
WindowMargins->{{56, Automatic}, {26, Automatic}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 869, 20, 331, "Input"],

Cell[CellGroupData[{
Cell[2611, 73, 2408, 33, 539, "Input"],
Cell[5022, 108, 2121, 32, 251, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7180, 145, 43, 1, 27, "Input"],
Cell[7226, 148, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7318, 154, 38, 1, 27, "Input"],
Cell[7359, 157, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7451, 163, 38, 1, 27, "Input"],
Cell[7492, 166, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7584, 172, 38, 1, 27, "Input"],
Cell[7625, 175, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7717, 181, 38, 1, 27, "Input"],
Cell[7758, 184, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7850, 190, 38, 1, 27, "Input"],
Cell[7891, 193, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7983, 199, 38, 1, 27, "Input"],
Cell[8024, 202, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8116, 208, 38, 1, 27, "Input"],
Cell[8157, 211, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8249, 217, 38, 1, 27, "Input"],
Cell[8290, 220, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8382, 226, 2225, 33, 539, "Input"],
Cell[10610, 261, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10702, 267, 57, 1, 27, "Input"],
Cell[10762, 270, 55, 1, 26, "Output"]
}, Open  ]],
Cell[10832, 274, 202, 4, 59, "Input"],

Cell[CellGroupData[{
Cell[11059, 282, 314, 7, 91, "Input"],
Cell[11376, 291, 1915, 48, 77, "Output"]
}, Open  ]],
Cell[13306, 342, 2052, 49, 137, "Input"],

Cell[CellGroupData[{
Cell[15383, 395, 64, 1, 27, "Input"],
Cell[15450, 398, 55, 1, 26, "Output"]
}, Open  ]],
Cell[15520, 402, 265, 5, 59, "Input"],

Cell[CellGroupData[{
Cell[15810, 411, 48, 1, 27, "Input"],
Cell[15861, 414, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15953, 420, 48, 1, 27, "Input"],
Cell[16004, 423, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16096, 429, 48, 1, 27, "Input"],
Cell[16147, 432, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16239, 438, 48, 1, 27, "Input"],
Cell[16290, 441, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16382, 447, 48, 1, 27, "Input"],
Cell[16433, 450, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16525, 456, 48, 1, 27, "Input"],
Cell[16576, 459, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16668, 465, 48, 1, 27, "Input"],
Cell[16719, 468, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16811, 474, 48, 1, 27, "Input"],
Cell[16862, 477, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16954, 483, 47, 1, 27, "Input"],
Cell[17004, 486, 55, 1, 26, "Output"]
}, Open  ]],
Cell[17074, 490, 80, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[17179, 495, 184, 3, 59, "Input"],
Cell[17366, 500, 54, 1, 26, "Output"]
}, Open  ]],
Cell[17435, 504, 64, 1, 27, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

